
# Multi-tenant Music API

This is a starter Node.js + Express + Sequelize (MySQL) backend for a multi-tenant music distribution platform.
Features included in this package:
- Multi-tenant separation via `tenant_id` on tenant-scoped tables
- Roles with default `musicfan` and admin levels (editor, supervisor, manager, admin)
- JWT authentication (register/login)
- Verification flow (upload gov ID + signature) and admin approval to promote to `artist`
- Basic Album & Track CRUD (tenant-scoped)
- Notifications & messaging tables (basic endpoints)
- Royalty/payout stubs for extension

## Quickstart (development)

1. Copy `.env.example` to `.env` and set values.
2. Install dependencies:
   ```bash
   npm install
   ```
3. Start MySQL and create database & user matching `.env`.
4. Run server:
   ```bash
   npm run dev
   ```

This project uses `sequelize.sync({ alter: true })` for development. For production, use migrations and proper secret management.
