
const { sequelize, Tenant, User } = require('../src/models');
(async () => {
  try {
    await sequelize.authenticate();
    const tenant = await Tenant.create({ name: 'Default Tenant', slug: 'default' });
    const admin = await User.create({ tenant_id: tenant.tenant_id, name: 'Admin User', email: 'admin@default.test' });
    await admin.setPassword('ChangeMe123!');
    admin.role = 'admin';
    await admin.save();
    console.log('Tenant and admin created', tenant.tenant_id, admin.user_id);
    process.exit(0);
  } catch (err) {
    console.error(err);
    process.exit(1);
  }
})();
