
const { Track } = require('../models');

async function createTrack(req, res) {
  try {
    const tenant_id = req.user.tenant_id;
    const { album_id, title, duration_seconds } = req.body;
    const artist_id = req.user.user_id;
    const track = await Track.create({ tenant_id, album_id, artist_id, title, duration_seconds });
    res.json({ ok: true, track });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'Create track failed' });
  }
}

async function listTracks(req, res) {
  try {
    const tenant_id = req.user.tenant_id;
    const tracks = await Track.findAll({ where: { tenant_id } });
    res.json({ ok: true, tracks });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: 'List tracks failed' });
  }
}

module.exports = { createTrack, listTracks };
