
const { Model, DataTypes } = require('sequelize');

class Message extends Model {
  static init(sequelize) {
    return super.init({
      message_id: { type: DataTypes.UUID, defaultValue: DataTypes.UUIDV4, primaryKey: true },
      tenant_id: { type: DataTypes.UUID, allowNull: false },
      conversation_id: { type: DataTypes.UUID },
      sender_user_id: { type: DataTypes.BIGINT.UNSIGNED },
      recipient_user_id: { type: DataTypes.BIGINT.UNSIGNED },
      body: { type: DataTypes.TEXT }
    }, { sequelize, tableName: 'messages' });
  }
}

module.exports = Message;
