
const { Model, DataTypes } = require('sequelize');

class Notification extends Model {
  static init(sequelize) {
    return super.init({
      notification_id: { type: DataTypes.UUID, defaultValue: DataTypes.UUIDV4, primaryKey: true },
      tenant_id: { type: DataTypes.UUID, allowNull: false },
      user_id: { type: DataTypes.BIGINT.UNSIGNED },
      type: { type: DataTypes.STRING },
      channel: { type: DataTypes.STRING, defaultValue: 'in_app' },
      payload: { type: DataTypes.JSON }
    }, { sequelize, tableName: 'notifications' });
  }
}

module.exports = Notification;
