
const { Model, DataTypes } = require('sequelize');

class Role extends Model {
  static init(sequelize) {
    return super.init({
      role_id: { type: DataTypes.BIGINT.UNSIGNED, primaryKey: true, autoIncrement: true },
      key: { type: DataTypes.STRING, unique: true, allowNull: false },
      name: { type: DataTypes.STRING, allowNull: false },
      level: { type: DataTypes.INTEGER, allowNull: false }
    }, { sequelize, tableName: 'roles', timestamps: false });
  }
  static associate() {
    const { User } = require('./index');
    this.belongsToMany(User, { through: 'user_roles', foreignKey: 'role_id' });
  }
}

module.exports = Role;
