
const { Model, DataTypes } = require('sequelize');

class RoyaltyLedger extends Model {
  static init(sequelize) {
    return super.init({
      ledger_id: { type: DataTypes.UUID, defaultValue: DataTypes.UUIDV4, primaryKey: true },
      tenant_id: { type: DataTypes.UUID, allowNull: false },
      track_id: { type: DataTypes.BIGINT.UNSIGNED },
      source: { type: DataTypes.STRING },
      period: { type: DataTypes.DATE },
      gross_amount: { type: DataTypes.DECIMAL(18,6), defaultValue: 0 },
      fees: { type: DataTypes.DECIMAL(18,6), defaultValue: 0 },
      net_amount: { type: DataTypes.DECIMAL(18,6), defaultValue: 0 }
    }, { sequelize, tableName: 'royalty_ledgers' });
  }
}

module.exports = RoyaltyLedger;
