
const { Model, DataTypes } = require('sequelize');

class Track extends Model {
  static init(sequelize) {
    return super.init({
      track_id: { type: DataTypes.BIGINT.UNSIGNED, autoIncrement: true, primaryKey: true },
      tenant_id: { type: DataTypes.UUID, allowNull: false },
      album_id: { type: DataTypes.BIGINT.UNSIGNED },
      artist_id: { type: DataTypes.BIGINT.UNSIGNED, allowNull: false },
      title: { type: DataTypes.STRING, allowNull: false },
      isrc: { type: DataTypes.STRING },
      audio_url: { type: DataTypes.STRING },
      duration_seconds: { type: DataTypes.DECIMAL(8,2) }
    }, { sequelize, tableName: 'tracks' });
  }

  static associate() {
    const { Album } = require('./index');
    this.belongsTo(Album, { foreignKey: 'album_id' });
  }
}

module.exports = Track;
