
require('dotenv').config();
const express = require('express');
const bodyParser = require('body-parser');
const cors = require('cors');
const { sequelize, Role } = require('./models');
const authRoutes = require('./routes/auth');
const verifyRoutes = require('./routes/verify');
const albumRoutes = require('./routes/albums');
const trackRoutes = require('./routes/tracks');

const app = express();
app.use(cors());
app.use(bodyParser.json());

app.use('/auth', authRoutes);
app.use('/verify', verifyRoutes);
app.use('/albums', albumRoutes);
app.use('/tracks', trackRoutes);

app.get('/', (req, res) => res.json({ ok: true, message: 'Multi-tenant Music API' }));

const PORT = process.env.PORT || 4848;

(async () => {
  try {
    await sequelize.authenticate();
    console.log('DB connected');
    await sequelize.sync({ alter: true });
    console.log('Sequelize synced');
    // Seed roles
    const roles = [
      { key: 'editor', name: 'Editor', level: 1 },
      { key: 'supervisor', name: 'Supervisor', level: 2 },
      { key: 'manager', name: 'Manager', level: 3 },
      { key: 'admin', name: 'Administrator', level: 4 }
    ];
    for (const r of roles) {
      await Role.findOrCreate({ where: { key: r.key }, defaults: r });
    }
    app.listen(PORT, () => console.log(`Server listening on ${PORT}`));
  } catch (err) {
    console.error('Startup error', err);
  }
})();
